/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tiviacz.travelersbackpack.client.screens.TravelersBackpackScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;

public abstract class WidgetBase
extends GuiComponent
implements Widget,
GuiEventListener,
NarratableEntry {
    public final TravelersBackpackScreen screen;
    protected int x;
    protected int y;
    protected int zOffset = 0;
    protected int width;
    protected int height;
    protected boolean isWidgetActive = false;
    protected boolean isVisible;
    protected boolean showTooltip;

    public WidgetBase(TravelersBackpackScreen screen, int x, int y, int width, int height) {
        this.screen = screen;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.zOffset != 0) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, (double)this.zOffset);
        }
        RenderSystem.m_69482_();
        this.renderBg(poseStack, Minecraft.m_91087_(), mouseX, mouseY);
        this.renderTooltip(poseStack, mouseX, mouseY);
        if (this.zOffset != 0) {
            poseStack.m_85849_();
        }
    }

    abstract void renderBg(PoseStack var1, Minecraft var2, int var3, int var4);

    abstract void renderTooltip(PoseStack var1, int var2, int var3);

    public boolean m_5953_(double pMouseX, double pMouseY) {
        return pMouseX >= (double)this.x && pMouseY >= (double)this.y && pMouseX < (double)(this.x + this.width) && pMouseY < (double)(this.y + this.height);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.m_5953_(pMouseX, pMouseY)) {
            this.setWidgetStatus(!this.isWidgetActive);
            this.screen.playUIClickSound();
            return true;
        }
        return false;
    }

    public void setWidgetStatus(boolean status) {
        this.isWidgetActive = status;
    }

    public boolean isWidgetActive() {
        return this.isWidgetActive;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visibility) {
        this.isVisible = visibility;
    }

    public void setTooltipVisible(boolean visible) {
        this.showTooltip = visible;
    }

    public boolean isSettingsChild() {
        return true;
    }

    public boolean in(int mouseX, int mouseY, int x, int y, int width, int height) {
        return x <= mouseX && mouseX <= x + width && y <= mouseY && mouseY <= y + height;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }

    public int[] getWidgetSizeAndPos() {
        int[] size = new int[]{this.x, this.y, this.width, this.height};
        return size;
    }
}

